/*
 * routines for manipulating routes
 */

#include "map.h"
#include "route.h"

int
load_route_file(struct routefile *rp,
                struct mapfile *mp)
{
  char buf[128];
  char **w;
  int wc;
  int i;
  int num_ent;
  int lhost;
  int rhost;

  rp->fp = fopen(rp->name, "r");
  assert(rp->fp != NULL);

  while (fgets(buf, sizeof(buf), rp->fp) != NULL) {
    w = line2words(buf, "	 ", 0, &wc);
    assert(wc == 4);

    /* first host line initialized the route struct */
    if (rp->num_hosts == 0) {
      rp->num_hosts = atoi(w[1]);
      rp->num_ports = atoi(w[2]);
      rp->num_routes = atoi(w[3]);

      /* compute multipliers for each dimension of 5-dim array */
      rp->lh_dim = rp->num_hosts * rp->num_ports * rp->num_ports
                   * rp->num_routes;
      rp->lp_dim = rp->num_hosts * rp->num_ports * rp->num_routes;
      rp->rh_dim = rp->num_ports * rp->num_routes;
      rp->rp_dim = rp->num_routes;

      fprintf(stderr, "array size is %d bytes\n",
	      rp->lh_dim * rp->num_hosts * sizeof(struct route));

      rp->entries = (struct route *) calloc(sizeof(struct route),
	      				    rp->lh_dim * rp->num_hosts);
      assert(rp->entries != NULL);

    } else {

	/* make sure all host lines match */
	assert(rp->num_hosts == atoi(w[1]));
	assert(rp->num_ports == atoi(w[2]));
	assert(rp->num_routes == atoi(w[3]));
    }

    /* get index for this host */
    lhost = symtab_lookup(mp->hsyms, w[0]);
    assert(lhost != -1);
    free(w);

    /* loop through all the entries and load the routes */
    num_ent = rp->num_hosts * rp->num_ports * rp->num_ports * rp->num_routes;
    for (i=0; i < num_ent; ++i) {
      char *rv;
      char **rw;

      rv = fgets(buf, sizeof(buf), rp->fp);
      assert(rv != NULL);

      w = line2words(buf, "	 ", 0, &wc);
      assert(wc == 5);

      /* find the remote host */
      rhost = symtab_lookup(mp->hsyms, w[1]);
      assert(rhost != -1);

      /* parse port and index info */
      lport = atoi(w[0]);
      rport = atoi(w[3]);
      index = atoi(w[2]);

      entry = ROUTE_ENTRY(mp, lhost, lport, rhost, rport, index);

    }
  }
}
